//********************************************************************
//  ParallelLines.java       Author: Lewis and Loftus
//
//  Solution to Programming Project 5.20 (5E, p. 288)
//********************************************************************

import javax.swing.JApplet;
import java.awt.*;

public class ParallelLines extends JApplet
{
   private final int NUM_LINES = 20;
   private final int MIN_LENGTH = 25;
   private final int MAX_EXTRA = 250;
   private final int START_X = 10;
   private final int GAP = 8;

   //-----------------------------------------------------------------
   //  Paints several parallel lines of random length.
   //-----------------------------------------------------------------
   public void paint(Graphics page)
   {
      int y = 5, length;

      setBackground (Color.black);

      page.setColor (Color.green);

      for (int count=1; count <= NUM_LINES; count++)
      {
         y += GAP;

         length = (int) (Math.random() * MAX_EXTRA) + MIN_LENGTH;

         page.drawLine (START_X, y, START_X+length, y);
      }
   }
}
